/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.environment;

import com.badlogic.gdx.ai.msg.MessageDispatcher;

public class GameClock {
    private static final double HOURS_IN_DAY = 24.0;
    private static final double MINUTES_IN_HOUR = 60.0;
    private static final double REAL_TIME_SECONDS_PER_GAME_DAY = 300.0;
    private double timeOfDay;
    private double currentGameTime;
    private boolean paused;
    private float speedMultiplier = 1.0f;
    private int dayOfMonth = 2;
    public static final int DAYS_IN_MONTH = 3;
    private final MessageDispatcher messageDispatcher;
    private StringBuilder formatter = new StringBuilder();

    public GameClock(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.currentGameTime = this.timeOfDay = 16.0;
    }

    public static double realTimeToGameHours(float deltaRealtimeSeconds) {
        return (double)deltaRealtimeSeconds / 300.0 * 24.0;
    }

    public static double gameHoursToRealTimeSeconds(float gameHours) {
        return (double)gameHours / 24.0 * 300.0;
    }

    public void update(float deltaRealtimeSeconds) {
        double elapsedHours = GameClock.realTimeToGameHours(deltaRealtimeSeconds);
        this.timeOfDay += elapsedHours;
        this.currentGameTime += elapsedHours;
        if (this.timeOfDay > 24.0) {
            this.timeOfDay -= 24.0;
            ++this.dayOfMonth;
            if (this.dayOfMonth > 3) {
                this.dayOfMonth = 1;
                this.messageDispatcher.dispatchMessage(501);
            }
        }
    }

    public double getGameTimeInHours() {
        return this.timeOfDay;
    }

    public String getFormattedGameTime() {
        this.formatter.setLength(0);
        int hours = (int)Math.floor(this.timeOfDay);
        int minutes = (int)Math.floor(this.timeOfDay % 1.0 * 60.0);
        if (hours < 10) {
            this.formatter.append(0);
        }
        this.formatter.append(hours).append(":");
        if (minutes < 10) {
            this.formatter.append(0);
        }
        this.formatter.append(minutes);
        return this.formatter.toString();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public double getCurrentGameTime() {
        return this.currentGameTime;
    }

    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public void setSpeedMultiplier(float speedMultiplier) {
        this.speedMultiplier = speedMultiplier;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }
}

